﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_BodyResonanceFilter
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;
        private c_body_resonance_filter _current_body_resonance_filter;

        #endregion

        #region "================ PROPERTIES ========================"
        public c_body_resonance_filter current_body_resonance_filter
        {
            get
            {
                if (_CGS.Table_body_resonance_filter.CurrentRow.RowIsEmpty == true)
                { return null; }
                else
                {
                    if ((_current_body_resonance_filter == null) ||(_CGS.Table_body_resonance_filter.CurrentRow.body_resonance_filter_id != _current_body_resonance_filter.body_resonance_filter_id))
                    {
                        set_current_body_resonance_filter(_CGS.Table_patch.CurrentRow.patch_id);
                    }
                }

                return _current_body_resonance_filter;
            }
        }
        #endregion

        #region "================ METHODS ========================"
        public BL_BodyResonanceFilter(CodeGen_DS_Spectral CGS, DA_Spectral DASP)
        {
            _CGS = CGS;
            _DASP = DASP;
        }

        public int add_new_body_resonance_filter(string new_filter_name)
        {

            int new_body_resonance_filter_id = _CGS.Table_body_resonance_filter.AddRow();
            set_current_body_resonance_filter(new_body_resonance_filter_id);
            if (new_filter_name != "") { current_body_resonance_filter.body_resonance_filter_name = new_filter_name; }
            current_body_resonance_filter.body_resonance_filter_guid8 = BL_Spectral.GetNewGuid8();
            for (Int32 b = 0; b < DA_Spectral.max_body_resonance_filter_bands; b++)
            {
                _CGS.Table_body_resonance_filter_band.DeleteRow(new_body_resonance_filter_id, b);//Ensure any existing row is deleted
                _CGS.Table_body_resonance_filter_band.AddRow3(new_body_resonance_filter_id, b, 255, 0);
            }

            return new_body_resonance_filter_id;
        }

        public void set_current_body_resonance_filter(Int32 body_resonance_filter_id)
        {
            _current_body_resonance_filter = new c_body_resonance_filter(_CGS, _DASP, body_resonance_filter_id);
            //TO DO: Set any filters here
        }

        #endregion

    }
}
